﻿___TERMS_OF_SERVICE___

By creating or modifying this file you agree to Google Tag Manager's Community
Template Gallery Developer Terms of Service available at
https://developers.google.com/tag-manager/gallery-tos (or such other URL as
Google may provide), as modified from time to time.


___INFO___

{
  "type": "TAG",
  "id": "cvt_temp_public_id",
  "version": 1,
  "securityGroups": [],
  "displayName": "Zeta Global - Include Signals SDK",
  "brand": {
    "id": "brand_dummy",
    "displayName": "",
    "thumbnail": "data:image/png;base64,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\u003d"
  },
  "description": "Use this tag to initialize the Signals SDK",
  "containerContexts": [
    "WEB"
  ]
}


___TEMPLATE_PARAMETERS___

[
  {
    "type": "TEXT",
    "name": "signalsSDK",
    "displayName": "Signals SDK Url",
    "simpleValueType": true,
    "valueValidators": [
      {
        "type": "NON_EMPTY",
        "errorMessage": "The url of the Signals SDK is not provided."
      }
    ]
  },
  {
    "type": "TEXT",
    "name": "apiKey",
    "displayName": "Signals SDK Api Key",
    "simpleValueType": true,
    "valueValidators": [
      {
        "type": "NON_EMPTY"
      }
    ]
  },
  {
    "type": "TEXT",
    "name": "apiHost",
    "displayName": "Signals API Url",
    "simpleValueType": true,
    "valueValidators": [
      {
        "type": "NON_EMPTY"
      }
    ]
  }
]


___SANDBOXED_JS_FOR_WEB_TEMPLATE___

// Enter your template code here.
const log = require('logToConsole');
const queryPermission = require('queryPermission');
const injectScript = require('injectScript');
const callInWindow = require('callInWindow');

log('data =', data);

const signalsSDK = data.signalsSDK;

function onSuccess() {
  callInWindow('Signals.setApiKey', data.apiKey);
  log('Call setAuthKey Succeeded.');

  callInWindow('Signals.setApiHost', data.apiHost);
  log('Call setApiHost Succeeded.');
  
  data.gtmOnSuccess();
}

// If the URL input by the user matches the permissions set for the template,
// inject the script with the onSuccess and onFailure methods as callbacks.
if (queryPermission('inject_script', signalsSDK)) {  
  log('Injecting Script.');  
  injectScript(signalsSDK, onSuccess, data.gtmOnFailure);  
} else {    
  log('Script load failed due to permissions mismatch.');  
  data.gtmOnFailure();  
}


___WEB_PERMISSIONS___

[
  {
    "instance": {
      "key": {
        "publicId": "logging",
        "versionId": "1"
      },
      "param": [
        {
          "key": "environments",
          "value": {
            "type": 1,
            "string": "debug"
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  },
  {
    "instance": {
      "key": {
        "publicId": "inject_script",
        "versionId": "1"
      },
      "param": [
        {
          "key": "urls",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 1,
                "string": "https://mmx-us-signals-js.s3.us-east-1.amazonaws.com/us/public/index.js"
              },
              {
                "type": 1,
                "string": "https://mmx-eu-signals-js.s3.eu-west-1.amazonaws.com/eu/public/index.js"
              },
              {
                "type": 1,
                "string": "https://mmx-jp-signals-js.s3.ap-northeast-1.amazonaws.com/jp/public/index.js"
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  },
  {
    "instance": {
      "key": {
        "publicId": "access_globals",
        "versionId": "1"
      },
      "param": [
        {
          "key": "keys",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "key"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  },
                  {
                    "type": 1,
                    "string": "execute"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "Signals.setApiHost"
                  },
                  {
                    "type": 8,
                    "boolean": true
                  },
                  {
                    "type": 8,
                    "boolean": true
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "key"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  },
                  {
                    "type": 1,
                    "string": "execute"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "Signals.setApiKey"
                  },
                  {
                    "type": 8,
                    "boolean": true
                  },
                  {
                    "type": 8,
                    "boolean": true
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  }
]


___TESTS___

scenarios: []


___NOTES___

Created on 2/19/2025, 9:49:18 AM


